/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.ai.BeAngryDuringBloodmoonGoal;
import dev.toma.gunsrpg.common.entity.BloodmoonGolemEntity;
import dev.toma.gunsrpg.common.entity.RocketAngelEntity;
import dev.toma.gunsrpg.config.world.MobHealthBuffConfig;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.object.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MobSpawnManager {
    private static final UUID HEALTH_BOOST_UUID = UUID.fromString("80096B27-0A64-47FF-A22A-06146FC42448");
    private static final MobSpawnManager INSTANCE = new MobSpawnManager();
    private final Map<EntityType<?>, BooleanConsumer<? extends Entity>> postSpawn = new HashMap();
    private final Map<EntityType<?>, List<Pair<Integer, BiFunction<ServerWorld, Vector3d, LivingEntity>>>> bloodmoonEntries = new HashMap();
    private final AttributeModifier health2x = new AttributeModifier(HEALTH_BOOST_UUID, "health2x", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final AttributeModifier health3x = new AttributeModifier(HEALTH_BOOST_UUID, "health3x", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final AttributeModifier health4x = new AttributeModifier(HEALTH_BOOST_UUID, "health4x", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public static MobSpawnManager instance() {
        return INSTANCE;
    }

    public void initialize() {
        this.registerBloodmoonEntry(EntityType.field_200748_an, 7, (world, vec3d) -> {
            CaveSpiderEntity spider = new CaveSpiderEntity(EntityType.field_200794_h, (World)world);
            spider.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return spider;
        });
        this.registerBloodmoonEntry(EntityType.field_200748_an, GunsRPG.config.world.mobConfig.rocketAngelSpawn.overworldChance(), (world, vec3d) -> {
            RocketAngelEntity rocketAngel = new RocketAngelEntity((World)world);
            rocketAngel.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return rocketAngel;
        });
        this.registerBloodmoonEntry(EntityType.field_200725_aD, 4, (world, vec3d) -> {
            BlazeEntity blaze = new BlazeEntity(EntityType.field_200792_f, (World)world);
            blaze.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return blaze;
        });
        this.registerBloodmoonEntry(EntityType.field_200725_aD, 4, (world, vec3d) -> {
            BloodmoonGolemEntity golem = new BloodmoonGolemEntity((World)world);
            golem.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            return golem;
        });
        this.registerBloodmoonEntry(EntityType.field_200741_ag, 10, (world, vec3d) -> {
            WitherSkeletonEntity witherSkeleton = new WitherSkeletonEntity(EntityType.field_200722_aA, (World)world);
            witherSkeleton.func_70107_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            witherSkeleton.func_213386_a((IServerWorld)world, world.func_175649_E(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c)), SpawnReason.NATURAL, null, null);
            return witherSkeleton;
        });
        this.registerPostSpawnAction(EntityType.field_200797_k, (bloodmoon, creeper) -> {
            if (creeper.field_70170_p.field_72995_K || !bloodmoon) {
                return;
            }
            if (creeper.func_70681_au().nextFloat() <= 0.2f) {
                LightningBoltEntity lightningBolt = new LightningBoltEntity(EntityType.field_200728_aG, creeper.field_70170_p);
                lightningBolt.setDamage(0.0f);
                creeper.func_241841_a((ServerWorld)creeper.field_70170_p, lightningBolt);
                creeper.func_70066_B();
                creeper.func_70606_j(creeper.func_110138_aP());
            }
            creeper.field_82225_f = 10;
        });
    }

    public boolean processSpawn(LivingEntity entity, ServerWorld world, boolean isBloodmoon) {
        BooleanConsumer<? extends Entity> consumer;
        AttributeModifierManager manager = entity.func_233645_dx_();
        if (isBloodmoon) {
            List<Pair> list = ModUtils.getNonnullFromMap(this.bloodmoonEntries, entity.func_200600_R(), Collections.emptyList());
            Random random = world.func_201674_k();
            Vector3d vec3d = entity.func_213303_ch();
            for (Pair pair : list) {
                if (random.nextInt(20) >= (Integer)pair.getLeft()) continue;
                entity.func_70106_y();
                LivingEntity replacement = (LivingEntity)((BiFunction)pair.getRight()).apply(world, vec3d);
                world.func_217376_c((Entity)replacement);
                return false;
            }
        }
        if (this.isExluded((Entity)entity)) {
            return true;
        }
        ModifiableAttributeInstance instance = manager.func_233779_a_(Attributes.field_233818_a_);
        instance.func_188479_b(HEALTH_BOOST_UUID);
        AttributeModifier modifier = this.getRandomModifier(world.func_201674_k());
        if (modifier != null) {
            instance.func_233767_b_(modifier);
            entity.func_70606_j(entity.func_110138_aP());
        }
        if ((consumer = this.postSpawn.get(entity.func_200600_R())) != null) {
            consumer.acceptBoolean(isBloodmoon, (Entity)entity);
        }
        if (entity instanceof MobEntity && entity instanceof IAngerable) {
            this.addBloodmoonAggroGoal((MobEntity)((IAngerable)((MobEntity)entity)));
        }
        return true;
    }

    private boolean isExluded(Entity entity) {
        return GunsRPG.config.world.mobConfig.mobHealthBuffs.isHealthBuffDisabled(entity.func_200600_R());
    }

    private <T extends Entity> void registerPostSpawnAction(EntityType<T> type, BooleanConsumer<T> action) {
        this.postSpawn.put(type, action);
    }

    private void registerBloodmoonEntry(EntityType<?> type, int chance, BiFunction<ServerWorld, Vector3d, LivingEntity> replacement) {
        List list = this.bloodmoonEntries.computeIfAbsent(type, cl -> new ArrayList());
        list.add(Pair.of(Math.max(1, chance), replacement));
    }

    private AttributeModifier getRandomModifier(Random random) {
        float f = random.nextFloat();
        MobHealthBuffConfig cfg = GunsRPG.config.world.mobConfig.mobHealthBuffs;
        return f < cfg.health4xChance ? this.health4x : (f < cfg.health3xChance ? this.health3x : (f < cfg.health2xChance ? this.health2x : null));
    }

    private <E extends MobEntity> void addBloodmoonAggroGoal(E entity) {
        entity.field_70715_bh.func_75776_a(1, (Goal)new BeAngryDuringBloodmoonGoal(entity));
    }

    @FunctionalInterface
    public static interface BooleanConsumer<T> {
        public void acceptBoolean(boolean var1, T var2);
    }
}

